@ECHO OFF
SETLOCAL
SET JDKPATH=..\..\..\..\..\Externals\JDK1_2\bin
IF NOT EXIST "%JDKPATH%\javac.exe" GOTO errJavacNotFound

ECHO Compiling java code...
DEL *.class /S /Q /F >NUL 2>NUL
"%JDKPATH%\javac.exe" -d .. InjectTestWithCallbacks.java

IF ERRORLEVEL 1 goto badCompile
FOR %%a IN (Java*.java) DO (
  "%JDKPATH%\javac.exe" %%a
  IF ERRORLEVEL 1 goto badCompile
)

ECHO Packaging...
"%JDKPATH%\jar.exe" cvmf manifest.mf ..\JavaTest.jar Java*.class
IF ERRORLEVEL 1 goto badPackaging
GOTO end

:errJavacNotFound
ECHO Error: Java compiler not found
GOTO end

:badCompile
ECHO Error: While compiling java code
GOTO end

:badPackaging
ECHO Error: While packaging java classes
GOTO end

:end
ENDLOCAL
