import java.lang.*;

class InjectTestWithCallbacks
{
	//--------------------------------------------------------------------------
	//Injected class with native callbacks test

	public static native int noParametersReturningInt();
	public static native Object noParametersReturningJavaLangDoubleObject();
	public static native int withParametersReturningInt(String strParam, Object objParam, int[][] intArrayParam, double dblValue, Float[] floatObjArrayParam);
	public static native Object withParametersReturningJavaLangDoubleObject(String strParam, Object objParam, int[][] intArrayParam, double dblValue, Float[] floatObjArrayParam);

	public int Test_NoParametersReturningInt()
	{
		return noParametersReturningInt();
	}

	public Object Test_NoParametersReturningJavaLangDoubleObject()
	{
		return noParametersReturningJavaLangDoubleObject();
	}

	public int Test_WithParametersReturningInt()
	{
		Float[] flt = new Float[2];
		flt[0] = new Float(10.0);
		flt[1] = new Float(20.0);
		int[][] intArray = new int[2][3];
		for (int i=0; i<2; i++)
		{
			for (int j=0; j<3; j++)
				intArray[i][j] = i+j;
		}
		return withParametersReturningInt("Test_WithParametersReturningInt", new Integer(35), intArray, 50.0, flt);
	}

	public Object Test_WithParametersReturningJavaLangDoubleObject()
	{
		Float[] flt = new Float[2];
		flt[0] = new Float(10.0);
		flt[1] = new Float(20.0);
		int[][] intArray = new int[2][3];
		for (int i=0; i<2; i++)
		{
			for (int j=0; j<3; j++)
				intArray[i][j] = i+j;
		}
		return withParametersReturningJavaLangDoubleObject("Test_WithParametersReturningJavaLangDoubleObject", new Integer(35), intArray, 50.0, flt);
	}
}
